require( "scripts/style.lua" );

SliderFont = {
  standardFont,
  16,
  BlackColor
};

CheckFont = {
  standardFont,
  24,
  BlackColor
};

vHSButtonGraphics=
{
	"buttons/btn_a_normal.png",
	"buttons/btn_a_down.png",
	"buttons/btn_a_over.png",
}

vHSButtonFontStyle = { standardFont, 16, BlackColor };


MakeDialog
{
	-- Name the modal dialog
	name="optionsmenu",
	Bitmap
	{
		image="backgrounds/dialog",
		x = kCenter,
		y = kCenter,
		
		OptionsWindow
		{
			x=0,y=0,w=kMax,h=kMax,
			
			Text
			{
				font = CheckFont,
				name = "title",
				x=105 -30,y=10,w=300,h=50,
				flags = kHAlignCenter + kVAlignCenter,
				label = "options"
			};
			
			Text
			{
				font = SliderFont,
				name = "sfx",
				x=60-30,y=55,w=60,h=50,
				flags = kHAlignCenter + kVAlignCenter,
				label = "sfxlevel"
			};
		
			Text
			{
				font = SliderFont,
				name = "music",
				x=60-30,y=125,w=60,h=50,
				flags = kHAlignCenter + kVAlignCenter,
				label = "musiclevel"
			};

			SetStyle(CheckboxButtonStyle),			
			Button{
				name="fullscreen",
				x=30+47-30,
				y=175+17,
				w=10,
				command=
				function()
					if (ToggleFullScreen() == false) then
						DisplayDialog { 
							"scripts/ok.lua", 
							body ="screenswitchfailed",
						};
					end
				end
				
			};
			
			Text
			{
				font = CheckFont,
				name = "fullscreenlabel",
				x=124-30,
				y=200,
				w=230,
				h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label="fullscreen",
			};
			
			Button{
				name="mutebox",
				x=205+47-30,
				y=175+17,
				w=10,
				command =
					function()
						ToggleSoundMute();
					end
			};
			
			Text
			{
				font = CheckFont,
				name = "mutesoundlabel",
				x=299-30,
				y=200,
				w=230,
				h=kMax,
				flags = kHAlignLeft + kVAlignTop,
				label="mutesound",
			};

			SetStyle(ButtonStyle),
			Button
			{
				x = kCenter - 70,
				y = kMax-65,
				name="back",
				label="back",
				graphics= vHSButtonGraphics,
				font	= vHSButtonFontStyle,
				type = kPush,
				command =
					function()
						SaveVolumes();
						SendGameMessage("end_options");
						PopModal("optionsmenu");
					end
			},
			
			Button
			{
				x = kCenter + 70,
				y = kMax-65,
				name="credits",
				label="credits",
				hflip   = true,
				graphics= vHSButtonGraphics,
				font	= vHSButtonFontStyle,
				type = kPush,
				command =
					function()
						DoModal("scripts/credits.lua");
					end
			},
			
			

			SetStyle(SliderStyle),
			Slider
			{
				name="sfxlevelslider",
				x = 135-30,
				y = 65,
				w = 270,
			};
			
			Slider
			{
				name="musiclevelslider",
				x = 135-30,
				y = 135,
				w = 270,
			};
		},
	},
}